#create a kegg pathway dotplot
#install packages


# Load required packages
library(readxl)  # For reading Excel files
library(ggplot2) # For data visualization


# Load in Excel file
kegg_pathway_xls <- read_excel(file.choose(), sheet = 1)

# Construct ggplot

ggplot(kegg_pathway_xls, aes(x = `Gene ratio`, 
                                  y = `KEGG pathway`, 
                                  color = `padj value`, 
                                  size = Count)) +
  geom_point() +
  scale_size_continuous(range = c(2, 10)) +  # Adjust the range of point sizes
  scale_color_gradient(low = "red", high = "blue") +  # Adjust the color gradient to rainbow
  labs(x = "Gene ratio", 
       y = "KEGG pathway", 
       color = "padj value", 
       size = "Count") +
  ggtitle("Tercko/ko S. aureus vs Young S. aureus") +
  theme_minimal() + # Apply a minimal theme for better readability
  theme(
    plot.title = element_text(size = 20, face = "bold", hjust = 0.5)  # Customize title
  )

